package com.kwan.springbootkwan.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kwan.springbootkwan.entity.CsdnArticleInfo;
import com.kwan.springbootkwan.entity.resp.BusinessInfoResponse;
import com.kwan.springbootkwan.mapper.CsdnArticleInfoMapper;
import com.kwan.springbootkwan.service.CsdnArticleInfoService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * csdn文章信息(CsdnArticleInfo)表服务实现类
 *
 * @author makejava
 * @since 2023-10-28 01:58:46
 */
@Service("csdnArticleInfoService")
public class CsdnArticleInfoServiceImpl extends ServiceImpl<CsdnArticleInfoMapper, CsdnArticleInfo> implements CsdnArticleInfoService {

    @Value("${csdn.cookie}")
    private String csdnCookie;
    @Value("${csdn.url.user_article_url}")
    private String url;

    @Override
    public List<BusinessInfoResponse.ArticleData.Article> getArticles(String username) {
        HttpResponse response = HttpUtil.createGet(url)
                .header("Cookie", csdnCookie)
                .form("page", 1)
                .form("size", 10)
//                .form("businessType", "blog")
//                .form("blogType", "ViewCount")
                .form("businessType", "lately")
                .form("noMore", false)
                .form("username", username)
                .execute();
        final String body = response.body();
        ObjectMapper objectMapper = new ObjectMapper();
        BusinessInfoResponse businessInfoResponse;
        List<BusinessInfoResponse.ArticleData.Article> list = null;
        try {
            businessInfoResponse = objectMapper.readValue(body, BusinessInfoResponse.class);
            final BusinessInfoResponse.ArticleData data = businessInfoResponse.getData();
            list = data.getList();
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list;
    }

    @Override
    public List<BusinessInfoResponse.ArticleData.Article> getBlogs(String username) {
        HttpResponse response = HttpUtil.createGet(url)
                .header("Cookie", csdnCookie)
                .form("page", 1)
                .form("size", 10)
                .form("businessType", "blog")
//                .form("blogType", "ViewCount")
                .form("noMore", false)
                .form("username", username)
                .execute();
        final String body = response.body();
        ObjectMapper objectMapper = new ObjectMapper();
        BusinessInfoResponse businessInfoResponse;
        List<BusinessInfoResponse.ArticleData.Article> list = null;
        try {
            businessInfoResponse = objectMapper.readValue(body, BusinessInfoResponse.class);
            final BusinessInfoResponse.ArticleData data = businessInfoResponse.getData();
            list = data.getList();
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list;
    }
}

