package com.kwan.springbootkwan.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.kwan.springbootkwan.entity.User;

import java.util.List;

public interface IUserService extends IService<User> {

    /**
     * 获取所有用户
     *
     * @return
     */
    List<User> getUsers();

    /**
     * 获取一个用户
     *
     * @return
     */
    User getUserById(Integer id);

    /**
     * 根据姓名查询
     *
     * @param sex
     * @return
     */
    User getUserByName(String sex);

    /**
     * 保存用户
     *
     * @param user
     * @return
     */
    User saveUser(User user);

    /**
     * 使用or拼接数据
     *
     * @return
     */
    List<User> getUserByOr();

}
