package com.kwan.springbootkwan.schedule;

import com.kwan.springbootkwan.service.CsdnAutoReplyService;
import com.kwan.springbootkwan.service.CsdnService;
import com.kwan.springbootkwan.service.CsdnTripletDayInfoService;
import com.kwan.springbootkwan.service.CsdnUserInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class CsdnSchedule {

    @Autowired
    private CsdnService csdnService;
    @Autowired
    private CsdnUserInfoService csdnUserInfoService;
    @Autowired
    private CsdnAutoReplyService csdnAutoReplyService;
    @Autowired
    private CsdnTripletDayInfoService csdnTripletDayInfoService;

    @Scheduled(cron = "0 0 8,10,12,14,16,18,20 * * ?")
    public void execute() {
        log.info("execute task is running ... ...");
        csdnService.multiTriplet();
        csdnAutoReplyService.commentSelf();
        log.info("execute task is finish ... ...");
    }

    @Scheduled(cron = "0 0/30 * * * ?")
    public void resetAllCurrentStatus() {
        log.info("executeInit task is running ... ...");
        csdnUserInfoService.resetAllCurrentStatus();
        log.info("executeInit task is finish ... ...");
    }

    @Scheduled(cron = "0 0 1 * * ?")
    public void resetTripletDayInfo() {
        log.info("resetTripletDayInfo task is running ... ...");
        //新增当前天的新的一条数据
        csdnUserInfoService.resetUserDayStatus();
        csdnTripletDayInfoService.todayInfo();
        log.info("resetTripletDayInfo task is finish ... ...");
    }
}