package com.kwan.springbootkwan.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;

/**
 * 数据校验
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @Size 示一个字符串的长度或者一个集合的大小，必须在某一个范围中； min 参数表示范围的下限； max参数表示范围的上限； message 表示校验失败时的提示信息。
 * @NotNull 注解表示该字段不能为空。
 * @DecimalMin 注解表示对应属性值的下限，＠DecimalMax 注解表示对应属性值的上限
 * @Email 注解表示对应属性格式是一个 Email
 * @date : 2022/12/20 09:00
 */
@Data
public class Student {
    @ApiModelProperty(value = "主键")
    private Integer id;
    @ApiModelProperty(value = "姓名")
    @Size(min = 5, max = 10, message = "{user.name.size}")
    private String name;
    @ApiModelProperty(value = "地址")
    @NotNull(message = "{user.address.notnull}")
    private String address;
    @ApiModelProperty(value = "年龄")
    @DecimalMin(value = "1", message = "{user.age.size}")
    @DecimalMax(value = "200", message = "{user.age.size}")
    private Integer age;
    @ApiModelProperty(value = "邮箱")
    @Email(message = "{user.email.pattern}")
    @NotNull(message = "{user.email.notnull}")
    private String email;
}
