package com.kwan.springbootkwan.controller;

import com.kwan.springbootkwan.annotation.RedisLock;
import com.kwan.springbootkwan.entity.Department;
import com.kwan.springbootkwan.service.DepartmentService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 部门(Department)表控制层
 *
 * @author makejava
 * @since 2023-08-28 22:17:33
 */
@RestController
@RequestMapping("department")
public class DepartmentController {
    /**
     * 服务对象
     */
    @Resource
    private DepartmentService departmentService;

    /**
     * 分页查询
     *
     * @param department  筛选条件
     * @param pageRequest 分页对象
     * @return 查询结果
     */
    @GetMapping
    public ResponseEntity<Page<Department>> queryByPage(Department department, PageRequest pageRequest) {
        return ResponseEntity.ok(this.departmentService.queryByPage(department, pageRequest));
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("{id}")
    public ResponseEntity<Department> queryById(@PathVariable("id") Integer id) {
        //已知id=16,查询树结构
        return ResponseEntity.ok(this.departmentService.queryById(id));
    }

    /**
     * 已知id查询树结构
     *
     * @param id
     * @return
     */
    @GetMapping("/tree/{id}")
    public ResponseEntity<Department> queryTreeById(@PathVariable("id") Integer id) {
        //已知id=16,查询树结构
        return ResponseEntity.ok(this.departmentService.queryTreeById(id));
    }


    @GetMapping("/all")
    @RedisLock(key = "myLock_queryTreeAll", expire = 30000, timeout = 3000)
//    @RedisLock(key = "myLock_queryTreeAll", timeout = 10000)
    public ResponseEntity<List<Department>> queryTreeAll() {
        return ResponseEntity.ok(this.departmentService.queryTreeAll());
    }

    /**
     * 新增数据
     *
     * @param department 实体
     * @return 新增结果
     */
    @PostMapping
    public ResponseEntity<Department> add(Department department) {
        return ResponseEntity.ok(this.departmentService.insert(department));
    }

    /**
     * 编辑数据
     *
     * @param department 实体
     * @return 编辑结果
     */
    @PutMapping
    public ResponseEntity<Department> edit(Department department) {
        return ResponseEntity.ok(this.departmentService.update(department));
    }

    /**
     * 删除数据
     *
     * @param id 主键
     * @return 删除是否成功
     */
    @DeleteMapping
    public ResponseEntity<Boolean> deleteById(Integer id) {
        return ResponseEntity.ok(this.departmentService.deleteById(id));
    }
}