package com.kwan.springbootkwan.controller;

import com.kwan.springbootkwan.utils.ThreadPoolUntil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

/**
 * 方法上跨域配置
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2022/12/19 16:10
 */
@Api(tags = "BookController")
@RestController
public class BookController {


    @ApiOperation(value = "异步添加书籍", notes = "异步添加书籍")
    @CrossOrigin(maxAge = 1800, allowedHeaders = "*")
    @PostMapping("addBookAsyn")
    public DeferredResult<String> addBookAsyn(String name) {
        DeferredResult<String> deferredResult = new DeferredResult<>(10000L);
        // 设置超时处理
        deferredResult.onTimeout(() -> deferredResult.setErrorResult("请求超时"));
        // 设置错误处理
        deferredResult.onError((Throwable t) -> deferredResult.setErrorResult("系统错误"));
        // 创建任务
        Runnable task = () -> deferredResult.setResult("receive：" + name);
        ThreadPoolUntil.executeTask(task);
        return deferredResult;
    }

    @ApiOperation(value = "添加书籍", notes = "添加书籍")
    @CrossOrigin(value = "http://localhost:8081", maxAge = 1800, allowedHeaders = "*")
    @PostMapping("addBook")
    public String addBook(String name) {
        return "receive：" + name;
    }

    @ApiOperation(value = "删除书籍", notes = "删除书籍")
    @CrossOrigin(value = "http://localhost:8081", maxAge = 1800, allowedHeaders = "*")
    @DeleteMapping("deleteBook/{id}")
    public String deleteBook(@PathVariable(value = "id") String id) {
        return "receive：" + id;
    }
}