package com.kwan.springbootkwan.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@ApiModel(value = "财年周")
public class AdsDimFinancialYearWeekInfo extends Model<AdsDimFinancialYearWeekInfo> {
    @TableId
    @ApiModelProperty(value = "财年")
    private Integer financialYear;
    @ApiModelProperty(value = "第n财年周")
    private Integer financialYearWeek;
    @ApiModelProperty(value = "财年开始日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date financialYearStart;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "财年结束日期")
    private Date financialYearEnd;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "周开始")
    private Date weekStartDay;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "周结束")
    private Date weekEndDay;
    @ApiModelProperty(value = "财年周所在季节区间,0:跨9月1号,1:3月到8月,2:9月到2月 ")
    private Integer weekInSeason;
}