//package com.kwan.springbootkwan.config;
//
//import com.kwan.springbootkwan.entity.Person;
//import org.springframework.batch.core.Job;
//import org.springframework.batch.core.Step;
//import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
//import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
//import org.springframework.batch.core.configuration.annotation.StepScope;
//import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
//import org.springframework.batch.item.database.JdbcBatchItemWriter;
//import org.springframework.batch.item.file.FlatFileItemReader;
//import org.springframework.batch.item.file.mapping.BeanWrapperFieldSetMapper;
//import org.springframework.batch.item.file.mapping.DefaultLineMapper;
//import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.context.annotation.Bean;
//import org.springframework.context.annotation.Configuration;
//import org.springframework.core.io.ClassPathResource;
//
//import javax.sql.DataSource;
//
//@Configuration
//public class CsvBatchJobConfig {
//
//
//    @Autowired
//    JobBuilderFactory jobBuilderFactory;
//    @Autowired
//    StepBuilderFactory stepBuilderFactory;
//    @Autowired
//    DataSource dataSource;
//
//
//    @Bean
//    @StepScope
//    FlatFileItemReader<Person> itemReader() {
//        FlatFileItemReader<Person> reader = new FlatFileItemReader<>();
//        reader.setLinesToSkip(1);
//        reader.setResource(new ClassPathResource("data.csv"));
//        reader.setLineMapper(new DefaultLineMapper<Person>() {{
//            setLineTokenizer(new DelimitedLineTokenizer() {
//                {
//                    setNames("id", "username", "address", "gender");
//                    //配置列与列之间的间隔符（将通过间隔符对每一行的数据进行切分），最后设置要映射的实体类属性即可
//                    setDelimiter(",");
//                }
//            });
//            setFieldSetMapper(new BeanWrapperFieldSetMapper<Person>() {
//                {
//                    setTargetType(Person.class);
//                }
//            });
//
//        }});
//        return reader;
//    }
//
//    @Bean
//    public JdbcBatchItemWriter jdbcBatchItemWriter() {
//        JdbcBatchItemWriter writer = new JdbcBatchItemWriter();
//        writer.setDataSource(dataSource);
//        writer.setSql("insert into person(id, username,address,gender)" + "values (:id, :username, :address, :gender)");
//        writer.setItemSqlParameterSourceProvider(new BeanPropertyItemSqlParameterSourceProvider<>());
//        return writer;
//    }
//
//    @Bean
//    Step csvStep() {
//        return stepBuilderFactory.get("csvStep")
//                .<Person, Person>chunk(2)
//                .reader(itemReader())
//                .writer(jdbcBatchItemWriter())
//                .build();
//    }
//
//    @Bean
//    Job csvJob() {
//        return jobBuilderFactory.get("csvJob")
//                .start(csvStep())
//                .build();
//
//    }
//}
