package com.kwan.springbootkwan.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.entity.resp.BusinessInfoResponse;
import com.kwan.springbootkwan.enums.CollectStatus;
import com.kwan.springbootkwan.enums.CommentStatus;
import com.kwan.springbootkwan.enums.LikeStatus;
import com.kwan.springbootkwan.mapper.CsdnUserInfoMapper;
import com.kwan.springbootkwan.service.CsdnArticleService;
import com.kwan.springbootkwan.service.CsdnCollectService;
import com.kwan.springbootkwan.service.CsdnUserInfoService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * csdn用户信息(CsdnUserInfo)表服务实现类
 *
 * @author makejava
 * @since 2023-10-23 16:03:14
 */
@Service("csdnUserInfoService")
public class CsdnUserInfoServiceImpl extends ServiceImpl<CsdnUserInfoMapper, CsdnUserInfo> implements CsdnUserInfoService {


    @Autowired
    private CsdnCollectService csdnCollectService;
    @Autowired
    private CsdnArticleService csdnArticleService;

    @Override
    public void resetAllCurrentStatus() {
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        final List<CsdnUserInfo> list = this.list(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            for (CsdnUserInfo csdnUserInfo : list) {
                this.resetCsdnUserInfo(csdnUserInfo);
            }
        }
    }

    @Override
    public void resetCsdnUserInfo(CsdnUserInfo csdnUserInfo) {
        final String userName = csdnUserInfo.getUserName();
        final Integer commentStatus = csdnUserInfo.getCommentStatus();
        final String articleType = csdnUserInfo.getArticleType();
        final List<BusinessInfoResponse.ArticleData.Article> articles = csdnArticleService.getArticles(userName);
        if (CollectionUtil.isNotEmpty(articles)) {
            final BusinessInfoResponse.ArticleData.Article article = articles.get(0);
            final String type = article.getType();
            if (StringUtils.equals(type, "blog")) {
                final String urlInfo = article.getUrl();
                String articleId = urlInfo.substring(urlInfo.lastIndexOf("/") + 1);
                final Boolean collect = csdnCollectService.isCollect(articleId, csdnUserInfo);
                if (!collect || CommentStatus.COMMENT_TOO_FAST.getCode().equals(commentStatus) || !StringUtils.equals(articleType, type)) {
                    csdnUserInfo.setLikeStatus(LikeStatus.UN_PROCESSED.getCode());
                    csdnUserInfo.setCollectStatus(CollectStatus.UN_PROCESSED.getCode());
                    csdnUserInfo.setCommentStatus(CommentStatus.UN_PROCESSED.getCode());
                    csdnUserInfo.setArticleType(type);
                    this.updateById(csdnUserInfo);
                }
            }
        }
    }

    @Override
    public void resetUserDayStatus() {
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        final List<CsdnUserInfo> list = this.list(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            for (CsdnUserInfo csdnUserInfo : list) {
                final String userName = csdnUserInfo.getUserName();
                final List<BusinessInfoResponse.ArticleData.Article> articles = csdnArticleService.getArticles(userName);
                if (CollectionUtil.isNotEmpty(articles)) {
                    final BusinessInfoResponse.ArticleData.Article article = articles.get(0);
                    final String type = article.getType();
                    if (StringUtils.equals(type, "blog")) {
                        //看看之前的状态
                        final Integer likeStatus = csdnUserInfo.getLikeStatus();
                        if (!LikeStatus.HAVE_ALREADY_LIKED.getCode().equals(likeStatus) && !LikeStatus.LIKE_SUCCESSFUL.getCode().equals(likeStatus)) {
                            csdnUserInfo.setLikeStatus(LikeStatus.UN_PROCESSED.getCode());
                        }
                        final Integer collectStatus = csdnUserInfo.getCollectStatus();
                        if (!CollectStatus.COLLECT_SUCCESSFUL.getCode().equals(collectStatus) && !CollectStatus.HAVE_ALREADY_COLLECT.getCode().equals(collectStatus)) {
                            csdnUserInfo.setCollectStatus(CollectStatus.UN_PROCESSED.getCode());
                        }
                        final Integer commentStatus = csdnUserInfo.getCommentStatus();
                        if (!CommentStatus.COMMENT_SUCCESSFUL.getCode().equals(commentStatus) && !CommentStatus.HAVE_ALREADY_COMMENT.getCode().equals(commentStatus)) {
                            csdnUserInfo.setCommentStatus(CommentStatus.UN_PROCESSED.getCode());
                        }
                        this.updateById(csdnUserInfo);
                    }
                }
            }
        }
    }
}


