package com.kwan.springbootkwan.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.kwan.springbootkwan.entity.Person;
import com.kwan.springbootkwan.entity.User;
import com.kwan.springbootkwan.mapper.UserMapper;
import com.kwan.springbootkwan.service.IPersonService;
import com.kwan.springbootkwan.service.IUserService;
import io.seata.spring.annotation.GlobalTransactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service
public class UserServiceImpl extends ServiceImpl<UserMapper, User> implements IUserService {

    @Autowired
    private UserMapper userMapper;
    @Autowired
    private IPersonService personService;

    @Override
    public List<User> getUsers() {
        return userMapper.selectList(null);
    }

    @Override
    public User getUserById(Integer id) {
        return userMapper.selectById(id);
    }

    @Override
    public User getUserByName(String sex) {
        User userByName = userMapper.getUserByName(sex);
        if (Objects.isNull(userByName)) {
            userByName = new User();
        }
        return userByName;
    }

    @DS(value = "kwan-ds")
    @GlobalTransactional
    @Override
    public User saveUser(User user) {
        userMapper.insert(user);
        Person person = new Person();
        person.setUsername(user.getName());
        person.setAddress("当铺");
        person.setGender(user.getSex());
        personService.savePerson(person);
        return user;
    }

    @Override
    public List<User> getUserByOr() {
        List<Integer> invFlag = new ArrayList<>();
        invFlag.add(1);
        invFlag.add(2);
        invFlag.add(3);
        invFlag.add(4);
        return userMapper.getUserByOr(invFlag);
    }
}