package com.kwan.springbootkwan;

import com.kwan.springbootkwan.entity.MailInfo;
import com.kwan.springbootkwan.entity.User;
import com.kwan.springbootkwan.mapper.UserMapper;
import com.kwan.springbootkwan.service.ISendMsgHandle;
import com.kwan.springbootkwan.utils.RedisIdWorker;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;


@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
public class UserServiceImplTest {

    @Autowired
    private UserMapper userService;
    @Autowired
    private ISendMsgHandle emailSendMsgHandle;

    @Test
    public void queryAll() {
        User user = userService.selectById(1);
        System.out.println(user);
    }

    /**
     * 发邮件
     */
    @Test
    void sendSimpleTextEmail() {
        MailInfo mailInfo = new MailInfo();
        mailInfo.setReceiver(new String[]{"qinyingjie@deepexi.com"});
        mailInfo.setSubject("测试主题");
        mailInfo.setContent("邮件内容");
        emailSendMsgHandle.sendSimpleTextEmail(mailInfo);
    }


    /**
     * 带html
     */
    @Test
    public void sendHTMLMail() {
        MailInfo mailBean = new MailInfo();
        //接收人
        mailBean.setReceiver(new String[]{"qinyingjie@deepexi.com"});
        mailBean.setSubject("SpringBootMailHTML之这是一封HTML格式的邮件");
        //抄送给谁
        mailBean.setCc(new String[]{"786775527@qq.com", "286968900@qq.com"});
        StringBuilder sb = new StringBuilder();
        sb.append("<h2>SpringBoot测试邮件HTML</h2>")
                .append("<p style='text-align:left'>这是一封HTML邮件...</p>")
                .append("<p> 时间为：" + new Date() + "</p>");
        mailBean.setContent(sb.toString());
        //true、false控制以普通文本发送还是以html格式发送
        emailSendMsgHandle.sendHtmlEmail(mailBean, true);
    }

    @Test
    void sendEmail() {
        MailInfo mailBean = new MailInfo();
        mailBean.setReceiver(new String[]{"qinyingjie@deepexi.com"});
        mailBean.setSubject("SpringBootMailHTML之这是一封HTML格式的邮件");
        //抄送给谁
        mailBean.setCc(new String[]{"786775527@qq.com", "286968900@qq.com"});
        StringBuilder sb = new StringBuilder();
        sb.append("<h2>SpringBoot测试邮件HTML</h2>")
                .append("<p style='text-align:left'>这是一封HTML邮件...</p>")
                .append("<p> 时间为：" + new Date() + "</p>");
        mailBean.setContent(sb.toString());
        mailBean.setAttachFileNames(new String[]{"/Users/Downloads/密码管理.xlsx", "/Users/Downloads/1635834323888.jpg"});
        emailSendMsgHandle.sendEnclosureEmail(mailBean);
    }

    @Test
    void sendEmail2() {
        MailInfo mailBean = new MailInfo();
        mailBean.setReceiver(new String[]{"qinyingjie@deepexi.com"});
        mailBean.setSubject("SpringBootMailHTML之这是一封HTML格式的邮件");
        mailBean.setCc(new String[]{"786775527@qq.com", "286968900@qq.com"});
        StringBuilder sb = new StringBuilder();
        sb.append("<h2>SpringBoot测试邮件HTML</h2>")
                .append("<p style='text-align:left'>这是一封HTML邮件...</p>")
                .append("<a href=http://www.baidu.com>点击进入百度</a><br/>")
                //内嵌图片
                .append("<img src=\"cid:a00000001\"><br/><br/>")
                .append("<img src=\"cid:a00000002\">")
                .append("<p> 时间为：" + new Date() + "</p>");
        mailBean.setContent(sb.toString());
        //附件
        mailBean.setAttachFileNames(new String[]{"/Users/Downloads/密码管理.xlsx", "/Users/Downloads/1635834323888.jpg"});
        //内嵌了多少张图片，如果没有，则new一个不带值的Map
        Map<String, String> image = new HashMap<>();
        image.put("a00000001", "/Users/Downloads/WechatIMG22.jpg");
        image.put("a00000002", "/Users/Downloads/face_1631083961355.png");

        mailBean.setImageMap(image);
        emailSendMsgHandle.sendEnclosureEmail(mailBean);
    }

    @Autowired
    private RedisIdWorker redisIdWorker;

    private ExecutorService es = Executors.newFixedThreadPool(500);


    @Test
    public void testWorkerId() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(300);
        Runnable task = () -> {
            for (int i = 0; i < 100; i++) {
                long id = redisIdWorker.nextId("order");
                System.out.println("id = " + id);
            }
            latch.countDown();
        };

        long begin = System.currentTimeMillis();
        for (int i = 0; i < 300; i++) {
            es.submit(task);
        }
        latch.await();
        long end = System.currentTimeMillis();
        System.out.println("times = " + (end - begin));

    }

}