package com.kwan.springbootkwan.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.kwan.springbootkwan.entity.CsdnUserInfo;
import com.kwan.springbootkwan.entity.Result;
import com.kwan.springbootkwan.service.CsdnService;
import com.kwan.springbootkwan.service.CsdnUserInfoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/csdn")
public class CsdnController {

    @Autowired
    private CsdnService csdnService;
    @Autowired
    private CsdnUserInfoService csdnUserInfoService;

    @GetMapping("/singleTriplet")
    public Result singleTriplet(@Param("username") String username) {
        QueryWrapper<CsdnUserInfo> wrapper = new QueryWrapper<>();
        wrapper.eq("is_delete", 0);
        wrapper.eq("user_name", username);
        final List<CsdnUserInfo> list = csdnUserInfoService.list(wrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            final CsdnUserInfo csdnUserInfo = list.get(0);
            csdnService.singleArticle(csdnUserInfo);
        }
        return Result.ok("单人三连完成");
    }

    @GetMapping("/multiTriplet")
    public Result multiTriplet() {
        csdnService.multiTriplet();
        return Result.ok("多人三连完成");
    }
}
