package com.kwan.springbootkwan.utils;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.Tuple;

import java.util.Set;

/**
 * redis商品排序工具类
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2022/12/22 10:01
 */
public class GoodsRankUtil {

    private static Jedis jedis;

    static {
        jedis = new Jedis("120.79.36.53", 6379);
    }

    /**
     * 排序的Key
     */
    private static String KEY = "goods";

    /**
     * zrem——移除某个商品
     * 命令格式：***zrem 排行榜名称 商品标识*** 时间复杂度：O(log(N))
     */
    public static void removeOne() {

        Long aLong = jedis.zrem(KEY, "god-10");
    }

    /**
     * zincrby——增减商品分数
     * 命令格式：***zincrby 排行榜名称 分数增量 商品标识*** 时间复杂度：O(log(N))
     * 有的排行榜是在变更时重新设置商品的分数，而还有的排行榜则是以增量方式修改商品分数，增量可正可负。如果执行zincrby时商品尚不在排行榜中，则认为其原始分数为0，相当于执行zdd。
     */
    public static void addScore() {

        Double zincrby = jedis.zincrby(KEY, 1, "god-10");
        System.out.println(zincrby);
    }

    /**
     * zrevrank——查看商品的排名
     * 命令格式：***zrevrank 排行榜名称 商品标识*** 时间复杂度：O(log(N))
     * 与zrevrange类似，zrevrank是以分数由高到低的排序返回商品排名（实际返回的是以0开始的索引），对应的zrank则是以分数由低到高的排序返回排名。
     */
    public static void getNum() {

        Long aLong = jedis.zrevrank(KEY, "god-10");
        System.out.println(aLong);
        Long aLong2 = jedis.zrevrank(KEY, "god-1000");
        System.out.println(aLong2);
    }

    /**
     * zrevrange——按名次查看排行榜
     * 命令格式：***zrevrange 排行榜名称 起始位置 结束位置 [withscores]*** 时间复杂度：O(log(N)+M)
     * 由于排行榜一般是按照分数由高到低排序的，所以我们使用zrevrange，而命令zrange是按照分数由低到高排序。
     * 起始位置和结束位置都是以0开始的索引，且都包含在内。如果结束位置为-1则查看范围为整个排行榜。
     * 带上withscores则会返回商品分数。
     */
    public static void getRange() {

        Set<String> zrevrange = jedis.zrevrange(KEY, 2, 5);
        zrevrange.forEach(System.out::println);
        Set<Tuple> set = jedis.zrangeWithScores(KEY, 2, 5);
        set.forEach(System.out::println);
    }

    /**
     * zscore——查看商品分数
     * 命令格式：***zscore 排行榜名称 商品标识*** 时间复杂度：O(1)
     */
    public static void getData() {

        Double zscore = jedis.zscore(KEY, "go-20");
        System.out.println(zscore);
    }

    /**
     * zadd——设置商品分数
     * 命令格式：***zadd 排行榜名称 分数 商品名字 时间复杂度：O(log(N))
     */
    public static void setData() {
        for (int i = 0; i < 100; i++) {

            jedis.zadd(KEY, i, "go-" + i);
        }
    }
}