package com.kwan.springbootkwan.service.impl;

import com.kwan.springbootkwan.entity.Department;
import com.kwan.springbootkwan.mapper.DepartmentMapper;
import com.kwan.springbootkwan.service.DepartmentService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * 部门(Department)表服务实现类
 *
 * @author makejava
 * @since 2023-08-28 22:17:34
 */
@Service("departmentService")
public class DepartmentServiceImpl implements DepartmentService {
    @Resource
    private DepartmentMapper departmentDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public Department queryById(Integer id) {
        return this.departmentDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param department  筛选条件
     * @param pageRequest 分页对象
     * @return 查询结果
     */
    @Override
    public Page<Department> queryByPage(Department department, PageRequest pageRequest) {
        long total = this.departmentDao.count(department);
        return new PageImpl<>(this.departmentDao.queryAllByLimit(department, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param department 实例对象
     * @return 实例对象
     */
    @Override
    public Department insert(Department department) {
        this.departmentDao.insert(department);
        return department;
    }

    /**
     * 修改数据
     *
     * @param department 实例对象
     * @return 实例对象
     */
    @Override
    public Department update(Department department) {
        this.departmentDao.update(department);
        return this.queryById(department.getId());
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Integer id) {
        return this.departmentDao.deleteById(id) > 0;
    }

    @Override
    public Department queryTreeById(Integer id) {
        Department departmentDTO = new Department();
        departmentDTO.setId(0);
        queryChildren(departmentDTO);
        return departmentDTO;
    }

    @Override
    public List<Department> queryTreeAll() {
        //先找出父id为0的部门
        List<Department> children = departmentDao.queryByParentId(0);
        for (Department child : children) {
            child.setChildren(queryChildren(child));
        }
        return children;
    }

    /**
     * 递归查询
     *
     * @param parent
     */
    private List<Department> queryChildren(Department parent) {
        List<Department> children = departmentDao.queryByParentId(parent.getId());
        if (CollectionUtils.isEmpty(children)) {
            return null;
        }
        for (Department child : children) {
            child.setChildren(queryChildren(child));
        }
        return children;
    }
}