package com.kwan.springbootkwan.entity.dto;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kwan.springbootkwan.entity.CsdnTripletDayInfo;
import com.kwan.springbootkwan.mapstruct.FromConverter;
import lombok.Data;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.Date;


@Data
public class CsdnTripletDayInfoDTO extends Model<CsdnTripletDayInfoDTO> {
    //主键id
    private Integer id;
    //三连日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tripletDate;
    //点赞数量
    private Integer likeNum;
    //收藏数量
    private Integer collectNum;
    //评论数量
    private Integer commentNum;
    //创建时间
    private Date createTime;
    //更新时间
    private Date updateTime;
    //逻辑删除,0未删除,1已删除
    private Integer isDelete;

    @Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
    public interface Converter extends FromConverter<CsdnTripletDayInfoDTO, CsdnTripletDayInfo> {
        Converter INSTANCE = Mappers.getMapper(Converter.class);
    }
}