package com.kwan.springbootkwan.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 每日三连监控(CsdnTripletDayInfo)表实体类
 *
 * @author makejava
 * @since 2023-10-26 20:55:31
 */
@Data
@TableName("csdn_triplet_day_info")
public class CsdnTripletDayInfo extends Model<CsdnTripletDayInfo> {
    //主键id
    private Integer id;
    //三连日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tripletDate;
    //点赞数量
    private Integer likeNum;
    //收藏数量
    private Integer collectNum;
    //评论数量
    private Integer commentNum;
    //创建时间
    private Date createTime;
    //更新时间
    private Date updateTime;
    //逻辑删除,0未删除,1已删除
    private Integer isDelete;
}