package com.kwan.springbootkwan.controller;

import com.kwan.springbootkwan.entity.Student;
import com.kwan.springbootkwan.entity.User;
import com.kwan.springbootkwan.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/**
 * 用户相关
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2022/12/19 16:08
 */
@Slf4j
@Api(description = "用户信息", tags = "UserController")
@RestController
@RequestMapping("/user")
public class UserController {

    @Autowired
    private IUserService userService;

    @ApiOperation(value = "获取所有用户", notes = "获取所有用户")
    @RequestMapping(value = "/all", method = RequestMethod.GET)
    public List<User> addAdvertise() {
        log.info("测试日志={}", "success");
        return userService.getUsers();
    }

    @ApiOperation(value = "根据id获取用户信息", notes = "根据id获取用户信息")
    @RequestMapping(value = "/getUserById/{id}", method = RequestMethod.GET)
    public User getUserById(@PathVariable Integer id) {
        return userService.getUserById(id);
    }


    @PostMapping(value = "/student", produces = "application/json;charset=utf-8")
    public List<String> addUser(@RequestBody @Validated Student student, BindingResult result) throws UnsupportedEncodingException {
        List<String> errors = new ArrayList<>();
        if (result.hasErrors()) {
            List<ObjectError> allErrors = result.getAllErrors();
            for (ObjectError error : allErrors) {
                errors.add(error.getDefaultMessage());
            }
        }
        log.info("errors={}", errors);
        return errors;
    }

    @ApiOperation(value = "根据name获取用户信息", notes = "根据name获取用户信息")
    @RequestMapping(value = "/getUserByName", method = RequestMethod.GET)
    public User getUserByName(@RequestParam String sex) {
        return userService.getUserByName(sex);
    }


    @ApiOperation(value = "or拼接", notes = "or拼接")
    @RequestMapping(value = "/getUserByOr", method = RequestMethod.GET)
    public List<User> getUserByOr() {
        return userService.getUserByOr();
    }


}