package com.kwan.springbootkwan.controller;

import com.kwan.springbootkwan.entity.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

import static com.kwan.springbootkwan.constant.CommonConstant.PREFIX_REDIS_KEY;

@Slf4j
@Api(value = "redis测试信息", tags = "RedisController")
@RestController
@RequestMapping("/test")
public class RedisController {

    @Resource
    private RedisTemplate redisTemplate;

    @ApiOperation(value = "redis添加数据", notes = "redis添加数据")
    @GetMapping("/add")
    public Result add(String key, String value) {
        //向对应的key值添加数据
        redisTemplate.opsForValue().set(PREFIX_REDIS_KEY + key, value);
        //设置过期时间
        redisTemplate.expire(PREFIX_REDIS_KEY, 2000000, TimeUnit.SECONDS);
        return Result.ok();
    }

    @ApiOperation(value = "redis获取数据", notes = "redis获取数据")
    @GetMapping("/get")
    public Result get(String key) {
        //获取redis中的数据
        String value = (String) redisTemplate.opsForValue().get(PREFIX_REDIS_KEY + key);
        log.info("获取redis中的数据-->{}", value);
        return Result.ok(value);
    }
}
