package com.kwan.springbootkwan.utils;

import cn.hutool.core.collection.CollectionUtil;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * zip文件重命名
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2024/2/5 14:50
 */
public class RenameUtil {

    /**
     * 根据需要修改前缀
     */
//    private static final String PREFIX = "毕业设计&课设--";
//    private static final String PREFIX = "Matlab系列--";
//    private static final String PREFIX = "yolov8系列--";
//    private static final String PREFIX = "管理系统系列--";
    private static final String PREFIX = "【Html5系列】";
//    private static final String PREFIX = "";

    public static void main(String[] args) throws IOException {
        for (int i = 1; i < 2; i++) {
            // 请替换为你需要改名的文件夹路径
//            String folderPath = "C:\\data\\resource\\05-待上传\\0" + i;
            String folderPath = "D:\\data\\resource\\02-资源批量下载工具\\output";
//            String folderPath = "C:\\data\\resource\\04-待改名";
//        String folderPath = "/Users/qinyingjie/Downloads/资源上传/output";
            // 请替换为你敏感词大全文件位置
            String sentitivePath = "D:\\data\\vue-springboot-kwan\\src\\main\\resources\\sensitive.txt";
            Path path = Paths.get(sentitivePath);
            List<String> words = Files.readAllLines(path);
            try {
                processZipFiles(folderPath, words);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }


    private static void processZipFiles(String folderPath, List<String> words) throws IOException {
        Files.walk(Paths.get(folderPath)).filter(Files::isRegularFile).filter(path -> path.toString().toLowerCase().endsWith(".zip")).forEach(path -> {
            try {
                processSingleZipFile(path, words);
            } catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    /**
     * 处理单个文件
     *
     * @param filePath
     * @param words
     * @throws IOException
     */
    private static void processSingleZipFile(Path filePath, List<String> words) throws IOException {
        String oldFileName = filePath.getFileName().toString();
        String fileName = oldFileName;
        if (!oldFileName.contains(PREFIX)) {
            fileName = PREFIX + oldFileName;
        }
        try {
            // 判断是否为敏感文件
            Boolean tag = filterSensitiveFile(words, fileName);
            if (tag) {
                try {
                    // 敏感文件
                    System.out.println("敏感文件名称:" + fileName);
                    Files.delete(filePath);
                    System.out.println("文件删除成功: " + filePath);
                } catch (IOException e) {
                    System.err.println("无法删除文件: " + filePath);
                    e.printStackTrace();
                }
                return;
            }
            String emojiRegex = "[\\x{1F600}-\\x{1F64F}\\x{1F300}-\\x{1F5FF}\\x{1F680}-\\x{1F6FF}\\x{1F700}-\\x{1F77F}\\x{1F780}-\\x{1F7FF}\\x{1F800}-\\x{1F8FF}\\x{1F900}-\\x{1F9FF}\\x{1FA00}-\\x{1FA6F}\\x{2600}-\\x{26FF}\\x{2700}-\\x{27BF}\\x{2B50}]";
            // 使用正则表达式进行匹配和替换
            fileName = removeEmoji(fileName, emojiRegex).replace("2010", "")
                    .replace("2011", "")
                    .replace("2012", "")
                    .replace("2013", "")
                    .replace("2014", "")
                    .replace("2015", "")
                    .replace("2016", "")
                    .replace("2017", "")
                    .replace("2018", "")
                    .replace("2019", "")
                    .replace("2020", "")
                    .replace("2021", "")
                    .replace("2022", "")
                    .replace("2023", "")
                    .replace("2024", "")
                    .trim();
            // Step 2: Trim file name to 64 characters
            if (fileName.length() > 64) {
                fileName = fileName.substring(0, 58) + fileName.substring(fileName.length() - 4);
            }
            if (!StringUtils.equals(oldFileName, fileName)) {
                // 获取文件所在的目录
                Path directory = filePath.getParent();
                // 构建新的文件路径
                Path newPath = directory.resolve(fileName);
                // 使用Files.move()方法进行重命名
                Files.move(filePath, newPath);
                System.out.println("文件重命名成功！");
            }
        } catch (IOException e) {
            System.out.println("文件重命名失败: " + e.getMessage());
            if (e instanceof FileAlreadyExistsException) {
                // 使用Files.move()方法进行重命名
                // 获取文件所在的目录
                Path directory = filePath.getParent();
                // 构建新的文件路径
                // 生成0到100之间的随机数
                fileName = fileName.substring(0, fileName.length() - 4) + new Random().nextInt(101) + ".zip";
                Path newPath = directory.resolve(fileName);
                try {
                    Files.move(filePath, newPath);
                    System.out.println("文件重命名成功！");
                } catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    /**
     * 过滤敏感文件
     *
     * @param words
     * @param fileName
     * @return
     */
    private static Boolean filterSensitiveFile(List<String> words, String fileName) {
        if (CollectionUtil.isNotEmpty(words)) {
            for (String word : words) {
                if (fileName.contains(word)) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 使用正则表达式进行匹配和替换
     *
     * @param input
     * @param emojiRegex
     * @return
     */
    private static String removeEmoji(String input, String emojiRegex) {
        Pattern pattern = Pattern.compile(emojiRegex);
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll("");
    }
}