package com.kwan.springbootkwan.entity.openai;

import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;


@Slf4j
public class Main {

    /**
     * os.environ["OPENAI_API_KEY"] = ''
     * os.environ["OPENAI_API_BASE"] = 'https://opencatgpt.openai.azure.com/'
     * os.environ["OPENAI_API_TYPE"] = 'azure'
     * os.environ["OPENAI_API_VERSION"] = '2023-05-15'
     */
    public static void main(String[] args) throws Exception {
        final String question = "请解释一下java的多态";
        // 装配请求集合
        List<AzureAIMessage> azureAiMessageList = new ArrayList<>();
        AzureAIChatRequest azureAiChatRequest = new AzureAIChatRequest();

        AzureAIMessage azureAIMessage0 = new AzureAIMessage();
        azureAIMessage0.setRole(AzureAIRole.SYSTEM.toString());
        azureAIMessage0.setContent("你是一个AI机器人，请根据提问进行详细回答");

        azureAiMessageList.add(azureAIMessage0);
        execute(azureAiMessageList, azureAiChatRequest, question);
    }

    private static void execute(List<AzureAIMessage> azureAiMessageList, AzureAIChatRequest azureAiChatRequest
            , String question) throws Exception {
        AzureAIMessage azureAIMessage1 = new AzureAIMessage();
        azureAIMessage1.setRole(AzureAIRole.USER.toString());
        azureAIMessage1.setContent(question);
        azureAiMessageList.add(azureAIMessage1);

        azureAiChatRequest.setMessages(azureAiMessageList);
        azureAiChatRequest.setMaxTokens(1024);
        azureAiChatRequest.setTemperature(0.0);
        // 是否进行留式返回
        azureAiChatRequest.setPresencePenalty(0);
        azureAiChatRequest.setFrequencyPenalty(0);
        azureAiChatRequest.setStop(null);

        AzureAIClient azureAIClient = new AzureAIClient("https://opencatgpt.openai.azure.com/", "70846324f01c4e5cb3cc11da28a1e091",
                "gpt-35-turbo", "2023-05-15");
        AzureAIChatResponse azureAIChatResponse = azureAIClient.sendChatRequest(azureAiChatRequest);
        System.out.println(azureAIChatResponse.getChoices().get(0).getMessage());
    }
}
