package com.kwan.springbootkwan.utils;

import com.hankcs.hanlp.dictionary.py.Pinyin;
import com.hankcs.hanlp.dictionary.py.PinyinDictionary;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 拼音工具类
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/8/26 11:16
 */
public class PinyinUtil {

    /**
     * 获取中文完整拼音-不带音标
     *
     * @param chineseStr
     * @return
     */
    public static String getPinyin(String chineseStr) {
        List<Pinyin> pinyins = PinyinDictionary.convertToPinyin(chineseStr);
        StringBuilder stringBuilder = new StringBuilder();
        for (Pinyin pinyin : pinyins) {
            stringBuilder.append(pinyin.getPinyinWithoutTone());
        }
        return stringBuilder.toString();
    }

    /**
     * 获取中文完整拼音-指定分隔符
     *
     * @param chineseStr
     * @return
     */
    public static String getPinyin(String chineseStr, String separator) {
        List<Pinyin> pinyins = PinyinDictionary.convertToPinyin(chineseStr);
        StringBuilder stringBuilder = new StringBuilder();
        if (!CollectionUtils.isEmpty(pinyins)) {
            final int size = pinyins.size();
            for (int i = 0; i < size; i++) {
                if (i != 0 && i != size) {
                    stringBuilder.append(separator);
                }
                stringBuilder.append(pinyins.get(i).getPinyinWithoutTone());
            }
        }
        return stringBuilder.toString();
    }

    /**
     * 带音标
     *
     * @param chineseStr
     * @return
     */
    public static String getPinyinWithToneMark(String chineseStr) {
        List<Pinyin> pinyins = PinyinDictionary.convertToPinyin(chineseStr);
        StringBuilder stringBuilder = new StringBuilder();
        for (Pinyin pinyin : pinyins) {
            stringBuilder.append(pinyin.getPinyinWithToneMark());
        }
        return stringBuilder.toString();
    }

    /**
     * 获取中文拼音首字母
     *
     * @param chineseStr
     * @return
     */
    public static String getInitial(String chineseStr) {
        List<Pinyin> pinyins = PinyinDictionary.convertToPinyin(chineseStr);
        if (CollectionUtils.isEmpty(pinyins)) {
            return StringUtils.EMPTY;
        }
        return String.valueOf(pinyins.get(0).getPinyinWithoutTone().charAt(0));
    }

    public static void main(String[] args) {
        System.out.println(PinyinUtil.getPinyin("秦英杰", "_"));
        System.out.println(PinyinUtil.getInitial("秦英杰"));
    }
}