package com.kwan.springbootkwan.service;

import org.springframework.stereotype.Component;

import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArraySet;

@Component
@ServerEndpoint("/websocket")
public class WebSocketServer {
    //准备一个内部安全的集合 存放所有用户的websocket服务
    private static CopyOnWriteArraySet<WebSocketServer> wsset = new CopyOnWriteArraySet<>();
    private Session session;

    @OnOpen
    public void opOpen(Session session) {
        this.session = session;
        //将自身填充到set集合中 这个集合是所有客户端websocket的集合

        wsset.add(this);
//        sendMsg();


    }

    @OnClose
    public void onClose() {
        //将自己从set集合中删除
        wsset.remove(this);
    }

    @OnError
    public void onError(Session session, Throwable error) {
        System.out.println(this + "发生错误了");
    }

    //客户端发来消息
    @OnMessage
    public void onMessage(String clientMsg, Session session) {
        System.out.println("来自客户端的信息+“。。。。。。。。。”===》" + clientMsg);
        //每隔一秒给你推送一条当前时间信息
        sendAllClient(clientMsg);
    }

    private void sendMsg() {
        try {
            while (true) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String time = sdf.format(new Date());
                //发送数据
                this.session.getBasicRemote().sendText(time);
                Thread.sleep(1000);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void sendAllClient(String msg) {
        try {
            for (WebSocketServer wss : wsset) {
                wss.session.getBasicRemote().sendText(msg);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}