package com.kwan.springbootkwan.controller;

import com.kwan.springbootkwan.entity.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

import static com.kwan.springbootkwan.constant.CommonConstant.PREFIX_REDIS_KEY;


/**
 * redis测试信息
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2023/10/30 13:33
 */
@Slf4j
@Api(value = "redis测试信息", tags = "RedisController")
@RestController
@RequestMapping("/test")
public class RedisController {

    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private RedissonClient redissonClient;

    @ApiOperation(value = "redis添加数据", notes = "redis添加数据")
    @GetMapping("/add")
    public Result add(String key, String value) {
//        //向对应的key值添加数据
//        redisTemplate.opsForValue().set(PREFIX_REDIS_KEY + key, value);
//        //设置过期时间
//        redisTemplate.expire(PREFIX_REDIS_KEY, 2000000, TimeUnit.SECONDS);

        // 获取或创建一个 Redisson Map 对象，它类似于 Java 的 Map
        RMap<String, String> map = redissonClient.getMap("myMap");

        // 存储值
        map.put("key1", "value1");
        map.put("key2", "value2");

        // 检索值
        String value1 = map.get("key1");
        String value2 = map.get("key2");

        System.out.println("Value of key1: " + value1);
        System.out.println("Value of key2: " + value2);
        return Result.ok();
    }

    @ApiOperation(value = "redis获取数据", notes = "redis获取数据")
    @GetMapping("/get")
    public Result get(String key) {
        //获取redis中的数据
        String value = (String) redisTemplate.opsForValue().get(PREFIX_REDIS_KEY + key);
        log.info("获取redis中的数据-->{}", value);
        return Result.ok(value);
    }
}
