import com.kwan.spring5.dao.UserDao;
import com.kwan.spring5.dao.impl.UserDaoImpl;
import com.kwan.spring5.proxy.UserDaoProxy;
import org.junit.Test;

import java.lang.reflect.Proxy;

/**
 * jdk动态代理
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2022/11/12 18:43
 */
public class Spring_22_JDKProxy {

    @Test
    public void test1() {
        //创建接口实现类代理对象
        Class[] interfaces = {UserDao.class};
        UserDaoImpl userDao = new UserDaoImpl();
        /** 第一参数，类加载器
         第二参数，增强方法所在的类，这个类实现的接口，(支持多个接口)
         第三参数，实现这个接口 InvocationHandler，创建代理对象，写增强的部分  */
        UserDao dao = (UserDao) Proxy.newProxyInstance(Spring_22_JDKProxy.class.getClassLoader(), interfaces,
                new UserDaoProxy(userDao));
        int result = dao.add(1, 2);
        System.out.println("result:" + result);
    }

}
