package com.kwan.spring5.dao.impl;

import com.kwan.spring5.Book;
import com.kwan.spring5.dao.BookDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import java.util.Arrays;
import java.util.List;

/**
 * book-dao实现类
 *
 * @author : qinyingjie
 * @version : 2.2.0
 * @date : 2022/11/15 22:33
 */
@Repository
public class BookDaoImpl implements BookDao {
    /**
     * 注入 JdbcTemplate
     */
    @Autowired
    private JdbcTemplate jdbcTemplate;

    /**
     * 添加的方法
     *
     * @param book
     */
    @Override
    public void add(Book book) {
        //1 创建 sql 语句
        String sql = "INSERT INTO t_book VALUES(?,?,?)";
        //2 调用方法实现
        Object[] args = {book.getUserId(), book.getUsername(), book.getUstatus()};
        int update = jdbcTemplate.update(sql, args);
        System.out.println(update);
    }

    /**
     * 修改
     *
     * @param book
     */
    @Override
    public void updateBook(Book book) {
        String sql = "UPDATE t_book SET username=?,ustatus=? WHERE user_id=?";
        Object[] args = {book.getUsername(), book.getUstatus(), book.getUserId()};
        int update = jdbcTemplate.update(sql, args);
        System.out.println(update);
    }

    /**
     * 删除
     *
     * @param id
     */
    @Override
    public void delete(String id) {
        String sql = "DELETE FROM t_book WHERE user_id=?";
        int update = jdbcTemplate.update(sql, id);
        System.out.println(update);
    }

    /**
     * 查询表记录数
     *
     * @return
     */
    @Override
    public int selectCount() {
        String sql = "SELECT COUNT(*) FROM t_book";
        //queryForObject方法中：第一个参数代表--sql语句；第二个参数代表--返回类型class
        return jdbcTemplate.queryForObject(sql, Integer.class);
    }

    /**
     * 查询返回对象
     *
     * @param id
     * @return
     */
    @Override
    public Book findBookInfo(String id) {
        String sql = "SELECT * FROM t_book WHERE user_id=?";

        /*
         * queryForObject方法中：
         * 		第一个参数：sql语句
         * 		第二个参数：RowMapper 是接口，针对返回不同类型数据，使用这个接口里面 实现类 完成数据封装
         * 		第三个参数：sql 语句值
         */
        return jdbcTemplate.queryForObject(sql, new BeanPropertyRowMapper<>(Book.class), id);
    }

    /**
     * 所用场景：查询图书列表分页
     * 查询返回集合
     *
     * @return
     */
    @Override
    public List<Book> findAllBook() {
        String sql = "SELECT * FROM t_book";
        //调用方法
        return jdbcTemplate.query(sql, new BeanPropertyRowMapper<>(Book.class));
    }

    /**
     * 批量添加
     */
    @Override
    public void batchAddBook(List<Object[]> batchArgs) {
        String sql = "INSERT INTO t_book VALUES(?,?,?)";
        //batchUpdate方法 第一个参数：sql语句 第二个参数：List集合，添加多条记录数据
        int[] ints = jdbcTemplate.batchUpdate(sql, batchArgs);
        System.out.println(Arrays.toString(ints));
    }

    /**
     * 批量修改(同批量添加一样，调用同一个方法)
     */
    @Override
    public void batchUpdateBook(List<Object[]> batchArgs) {
        String sql = "UPDATE t_book SET username=?,ustatus=? WHERE user_id=?";
        int[] ints = jdbcTemplate.batchUpdate(sql, batchArgs);
        System.out.println(Arrays.toString(ints));
    }
}