from pyecharts.charts import Bar, Timeline
from pyecharts.options import *
from pyecharts.globals import ThemeType
from pyecharts import options as opts

# 读取数据
f = open("/Users/qinyingjie/Documents/python-workspace/python-demo/data/动态柱状图数据/csdn.csv", "r",
         encoding="UTF-8")
data_lines = f.readlines()
# 关闭文件
f.close()
# 删除第一条数据
data_lines.pop(0)
# 先定义一个字典对象
data_dict = {}
for line in data_lines:
    year = (line.split(",")[0])  # 日期
    country = line.split(",")[1]  # 昵称
    gdp = float(line.split(",")[2])  # 红包数据
    # 如何判断字典里面有没有指定的key呢？
    try:
        data_dict[year].append([country, gdp])
    except KeyError:
        data_dict[year] = []
        data_dict[year].append([country, gdp])

# 创建时间线对象
timeline = Timeline()
# timeline = Timeline({"theme": ThemeType.ROMANTIC})
# 排序年份
sorted_year_list = sorted(data_dict.keys())

for year in sorted_year_list:
    data_dict[year].sort(key=lambda element: element[1], reverse=True)
    # 取出本年份前8名的国家
    year_data = data_dict[year][0:8]
    x_data = []
    y_data = []
    for i, country_gdp in enumerate(year_data):
        x_data.append(country_gdp[0])  # x轴添加国家
        y_data.append(country_gdp[1])  # y轴添加gdp数据

    # 构建柱状图
    bar = Bar()
    x_data.reverse()
    y_data.reverse()
    bar.add_xaxis(x_data)
    colors = ['rgba(128, 128, 128, 0.5)']
    # colors=['rgba(128, 128, 128, 0.5)','red','red','red','red','red','red','red']
    bar.add_yaxis("红包数据", y_data
                  , itemstyle_opts=opts.ItemStyleOpts(
            #   color="red"
            color="blue"
        )
                  , label_opts=LabelOpts(position="right"))

    bar.reversal_axis()
    bar.set_global_opts(
        title_opts=TitleOpts(title=f"{year}-CSDN抢到红包累计排名"),
    )
    timeline.add(bar, str(year))

# 设置时间线自动播放
timeline.add_schema(
    play_interval=1500,
    is_timeline_show=True,
    is_auto_play=True,
    is_loop_play=False
)
# 绘图
timeline.render("颜色测试.html")
