import random

# 从序列中随机选择多个元素，不重复
items = random.sample(range(1, 11), 5)
print(items)

# 定义一个列表
items = ['apple', 'banana', 'cherry']

# 相同的概率
# 使用random.choices()随机选择3个元素，允许重复
# 第三个参数是每个元素被选择的概率，如果为None，则每个元素被选择的概率相同
# weights=None 表示每个元素被选择的概率相同。
item2 = random.choices(items, weights=None, cum_weights=None, k=3)

print(item2)

# 不同的概率
# 使用 cum_weights 进行选择时，每个元素的选择概率取决于其累积权重与总累积权重的比例。
# 例如，如果总累积权重是 10，而某个元素的累积权重是 5，那么这个元素被选中的概率是 50%。
# 这种方法可以用于实现更复杂的选择逻辑，例如基于概率分布的选择。
weights = [1, 2, 3]
item3 = random.choices(items, weights=weights, cum_weights=None, k=3)

print(item3)
