import os
import chainlit as cl

from langchain.chat_models import ChatOpenAI
from langchain.schema import (
    HumanMessage,
    SystemMessage
)

# 公司的key
os.environ["OPENAI_API_KEY"] = '70846324f01c4e5cb3cc11da28a1e091'
os.environ["OPENAI_API_BASE"] = 'https://opencatgpt.openai.azure.com/'
os.environ["OPENAI_API_TYPE"] = 'azure'
os.environ["OPENAI_API_VERSION"] = '2023-05-15'

chat = ChatOpenAI(model_name="gpt-35-turbo", engine="gpt-35-turbo")
history = [SystemMessage(content="你是一个聊天机器人，请回答下列问题。\n")]


@cl.on_message  # this function will be called every time a user inputs a message in the UI
async def main(message: str):
    # history = [SystemMessage(content="你是一个聊天机器人，请回答下列问题。\n")]
    history.append(HumanMessage(content=message))
    res = await cl.make_async(sync_func)()
    # res = chat(history)
    # print(res.content)
    # this is an intermediate step
    # await cl.Message(author="Tool 1", content=f"Response from tool1", indent=1).send()
    # send back the final answer
    history.append(res)
    await cl.Message(content=f"{res.content}").send()


def sync_func():
    return chat(history)
