"""
环形链表
"""
from typing import List, Optional


class ListNode:
    def __init__(self, val=0, next=None):
        self.val = val
        self.next = next


class Solution:
    def hasCycle(self, head: Optional[ListNode]) -> bool:
        """
        双指针,一个快指针,一个慢指针,如果有环 一定会相聚
        :param head:
        :return:
        """
        if head is None or head.next is None:
            return False
        slow = head
        fast = head.next
        while slow != fast:
            if fast is None or fast.next is None:
                return False
            slow = slow.next
            fast = fast.next.next
        return True


if __name__ == '__main__':
    l1 = ListNode(3)
    l1.next = ListNode(2)
    l1.next.next = ListNode(0)
    l1.next.next.next = ListNode(-4)
    # l1.next.next.next.next = ListNode(9)
    # l1.next.next.next.next.next = ListNode(9)
    # l1.next.next.next.next.next.next = ListNode(9)
    3, 2, 0, -4
    # l2 = ListNode(1)
    # l2.next = ListNode(3)
    # l2.next.next = ListNode(4)
    # # l2.next.next.next = ListNode(9)
    result = Solution().hasCycle(l1)
    print(result)
