"""
下一个更大元素 I
"""
from typing import List


class Solution:
    def nextGreaterElement(self, nums1: List[int], nums2: List[int]) -> List[int]:
        """
        使用栈解决
        栈顶元素肯定是比当前元素大的元素,否则取出,stack=[4,3,1] 2在遍历4的时候取出了
        :param nums1:
        :param nums2:
        :return:
        """
        stack = []
        next_map = {}
        res = []

        # 倒序遍历nums2
        for num in nums2[::-1]:
            while stack and stack[-1] < num:
                stack.pop()
            next_map[num] = stack[-1] if stack else -1
            stack.append(num)
        for num in nums1:
            res.append(next_map[num])
        return res


if __name__ == '__main__':
    result = Solution().nextGreaterElement([4, 1, 2], [1, 3, 4, 2])
    print(result)
