"""
移除元素
"""
from typing import List


class Solution:
    def removeElement(self, nums: List[int], val: int) -> int:
        """
        左指针 单指针遍历
        :param nums:
        :param val:
        :return:
        """
        left = 0
        for index in range(0, len(nums)):
            if nums[index] != val:
                nums[left] = nums[index]
                left += 1
        return left

    def removeElement2(self, nums: List[int], val: int) -> int:
        """
        双指针优化,左右夹逼
        :param nums:
        :param val:
        :return:
        """
        left = 0
        right = len(nums)
        while left < right:
            if nums[left] == val:
                nums[left] = nums[right - 1]
                right -= 1
            else:
                left += 1
        return left


if __name__ == '__main__':
    result = Solution().removeElement2([2], 3)
    print(result)
