"""
重构 2 行二进制矩阵
"""
from typing import List


class Solution:
    def reconstructMatrix(self, upper: int, lower: int, colsum: List[int]) -> List[List[int]]:
        # 初始化结果集
        n = len(colsum)
        res = [[0] * n for _ in range(2)]
        for i in range(n):
            if colsum[i] == 2:
                res[0][i] = 1
                res[1][i] = 1
                upper -= 1
                lower -= 1
            elif colsum[i] == 0:
                res[0][i] = 0
                res[1][i] = 0
            else:
                if upper > lower:
                    res[0][i] = 1
                    res[1][i] = 0
                    upper -= 1
                else:
                    res[0][i] = 0
                    res[1][i] = 1
                    lower -= 1
        if upper != 0 or lower != 0:
            return []
        return res


if __name__ == '__main__':
    # result = Solution().reconstructMatrix(2, 1, [1, 1, 1])
    result = Solution().reconstructMatrix(5, 5, [2, 1, 2, 0, 1, 0, 1, 2, 0, 1])
    print(result)
