"""
键盘行
"""
from typing import List


class Solution:
    def findWords(self, words: List[str]) -> List[str]:
        # 定义行字典,同一行的结果相同
        keyboard = {
            'q': 1, 'w': 1, 'e': 1, 'r': 1, 't': 1, 'y': 1, 'u': 1, 'i': 1, 'o': 1, 'p': 1,
            'a': 2, 's': 2, 'd': 2, 'f': 2, 'g': 2, 'h': 2, 'j': 2, 'k': 2, 'l': 2,
            'z': 3, 'x': 3, 'c': 3, 'v': 3, 'b': 3, 'n': 3, 'm': 3
        }
        res = []
        for word in words:
            # all表示每一项都满足条件
            if all(keyboard[word[0].lower()] == keyboard[char.lower()] for char in word):
                res.append(word)
        return res


if __name__ == '__main__':
    result = Solution().findWords(['Hello', 'Alaska', 'Dad', 'Peace'])
    print(result)
