"""
区域和检索 - 数组不可变
"""
from typing import List


class NumArray:

    def __init__(self, nums: List[int]):
        self.nums = nums
        for i in range(1, len(nums)):
            # 前缀和
            self.nums[i] += self.nums[i - 1]

    def sumRange(self, left: int, right: int) -> int:
        """
        切片  求和
        :param left:
        :param right:
        :return:
        """
        if left == 0:
            return self.nums[right]
        return self.nums[right] - self.nums[left - 1]


# Your NumArray object will be instantiated and called as such:
# obj = NumArray(nums)
# param_1 = obj.sumRange(left,right)
if __name__ == '__main__':
    result = NumArray([-2, 0, 3, -5, 2, -1]).sumRange(0, 2)
    print(result)
