"""
杨辉三角
"""
from typing import List


class Solution:
    def generate(self, numRows: int) -> List[List[int]]:
        """
        杨辉三角
        第一行只有一个元素 1；
        第 i 行有 i 个元素；
        每一行的第一个和最后一个元素都为 1；
        每个元素等于上一行中与其相邻的两个元素之和。
        :param numRows:
        :return:
        """
        if numRows == 0:
            return []
        result = [[1]]
        for i in range(1, numRows):
            # 当前行全为1
            row = [1] * (i + 1)
            # 只需要修改第二个和倒数第二个的值
            for j in range(1, i):
                # 值为上一行的左右2数相加
                row[j] = result[i - 1][j - 1] + result[i - 1][j]
            result.append(row)
        return result


if __name__ == '__main__':
    root = Solution().generate(1)
    print(root)
