"""
盛最多水的容器
"""
from typing import List


class Solution:
    def maxArea(self, height: List[int]) -> int:
        """
        双指针
        :param height:
        :return:
        """
        max_area = 0
        left = 0
        right = len(height) - 1
        while left < right:
            area = (right - left) * min(height[left], height[right])
            max_area = max(max_area, area)
            if height[left] < height[right]:
                left += 1
            else:
                right -= 1
        return max_area


if __name__ == '__main__':
    result = Solution().maxArea([1, 8, 6, 2, 5, 4, 8, 3, 7])
    print(result)
