"""
汇总区间
"""
from typing import List


def getRange(start, end):
    if start == end:
        return str(start)
    else:
        return str(start) + '->' + str(end)

class Solution:
    def summaryRanges(self, nums: List[int]) -> List[str]:
        """
        数组变量,差值不为1,则特殊处理
        :param nums:
        :return:
        """
        if not nums:
            return []
        result = []
        start = nums[0]
        for i in range(1, len(nums)):
            if nums[i] != nums[i - 1] + 1:
                result.append(getRange(start, nums[i - 1]))
                start = nums[i]
        result.append(getRange(start, nums[-1]))
        return result


if __name__ == '__main__':
    root = Solution().summaryRanges([0, 1, 2, 4, 5, 7])
    print(root)
