"""
链表的中间结点
"""
from typing import Optional


class ListNode:
    def __init__(self, val=0, next=None):
        self.val = val
        self.next = next


class Solution:
    def middleNode(self, head: Optional[ListNode]) -> Optional[ListNode]:
        """
        链表的中间结点,如果有2个 返回第二个  快慢指针
        :param head:
        :return:
        """
        fast, slow = head, head
        while fast and fast.next:
            slow = slow.next
            fast = fast.next.next
        return slow


if __name__ == '__main__':
    # 1, 2, 6, 3, 4, 5, 6
    l1 = ListNode(1)
    l1.next = ListNode(2)
    l1.next.next = ListNode(3)
    l1.next.next.next = ListNode(3)
    l1.next.next.next.next = ListNode(2)
    l1.next.next.next.next.next = ListNode(1)
    # l1.next.next.next.next.next.next = ListNode(7)
    # l2 = ListNode(5)
    # l2.next = ListNode(6)
    # l2.next.next = ListNode(1)
    # l2.next.next.next = ListNode(8)
    # l2.next.next.next.next = ListNode(4)
    # l2.next.next.next.next.next = ListNode(5)
    result = Solution().middleNode(l1)
    while result:
        print(result.val, end=' -> ')
        result = result.next
