"""
删除排序链表中的重复元素
"""
from typing import List, Optional


class ListNode:
    def __init__(self, val=0, next=None):
        self.val = val
        self.next = next


class Solution:
    def deleteDuplicates(self, head: Optional[ListNode]) -> Optional[ListNode]:
        dummy = head
        while dummy and dummy.next:
            # 如果当前节点和下一个节点的值相同，删除下一个节点
            if dummy.val == dummy.next.val:
                dummy.next = dummy.next.next
            else:
                dummy = dummy.next
        return head


if __name__ == '__main__':
    l1 = ListNode(1)
    l1.next = ListNode(1)
    l1.next.next = ListNode(2)
    # l1.next.next.next = ListNode(3)
    # l1.next.next.next.next = ListNode(9)
    # l1.next.next.next.next.next = ListNode(9)
    # l1.next.next.next.next.next.next = ListNode(9)

    # l2 = ListNode(1)
    # l2.next = ListNode(3)
    # l2.next.next = ListNode(4)
    # # l2.next.next.next = ListNode(9)
    result = Solution().deleteDuplicates(l1)
    while result:
        print(result.val, end=' -> ')
        result = result.next
