"""
在排序数组中查找元素的第一个和最后一个位置
"""

from typing import List


class Solution:
    def leftMost(self, nums: List[int], target: int) -> int:
        """
        最右侧符合的元素
        :param self:
        :param nums:
        :param target:
        :return:
        """
        left, right = 0, len(nums) - 1
        while left <= right:
            mid = (left + right) >> 1
            if target > nums[mid]:
                left = mid + 1
            else:
                right = mid - 1
        return left

    def rightMost(self, nums: List[int], target: int) -> int:
        """
        最右侧符合的元素
        :param self:
        :param nums:
        :param target:
        :return:
        """
        left, right = 0, len(nums) - 1
        while left <= right:
            mid = (left + right) >> 1
            if target < nums[mid]:
                right = mid - 1
            else:
                left = mid + 1
        return left - 1

    def searchRange(self, nums: List[int], target: int) -> List[int]:
        """
        在排序数组中查找元素的第一个和最后一个位置
        :param nums:
        :param target:
        :return:
        """
        a = self.leftMost(nums, target)
        b = self.rightMost(nums, target)
        if a <= b and nums[a] == target and nums[b] == target:
            return [a, b]
        else:
            return [-1, -1]


if __name__ == '__main__':
    result = Solution().searchRange([5, 7, 7, 8, 8, 10], 8)
    print(result)
