"""
二分查找平衡版
"""

from typing import List


class Solution:
    def distributeCoins(self, nums: List[int], target: int) -> int:
        """
        二分查找平衡版
        :param nums:
        :param target:
        :return:
        """
        left, right = 0, len(nums)
        while 1 < right - left:
            mid = (left + right) >> 1
            if nums[mid] > target:
                right = mid
            else:
                left = mid
        return left if target == nums[left] else -1


if __name__ == '__main__':
    result = Solution().distributeCoins([2, 7, 11, 15], 6)
    print(result)
