"""
在排序数组中查找元素的第一个和最后一个位置
"""

from typing import List


class Solution:

    def rightMost(self, nums: List[int], target: int) -> int:
        """
        最右侧符合的元素,优化只写一个
        :param self:
        :param nums:
        :param target:
        :return:
        """
        left, right, ans = 0, len(nums) - 1, len(nums)
        while left <= right:
            mid = (left + right) >> 1
            if target < nums[mid]:
                right = mid - 1
                # 当中间值大了时,把中间值给ans
                ans = mid
            else:
                left = mid + 1
        return ans

    def searchRange(self, nums: List[int], target: int) -> List[int]:
        """
        在排序数组中查找元素的第一个和最后一个位置
        :param nums:
        :param target:
        :return:
        """
        a = self.rightMost(nums, target - 1)
        b = self.rightMost(nums, target) - 1
        if a <= b and nums[a] == target and nums[b] == target:
            return [a, b]
        else:
            return [-1, -1]


if __name__ == '__main__':
    result = Solution().searchRange([5, 7, 7, 8, 8, 10], 8)
    print(result)
