"""
二分查找Leftmost
"""

from typing import List


class Solution:
    def distributeCoins(self, nums: List[int], target: int) -> int:
        """
        二分查找Leftmost,小于等于左侧的的位置
        :param nums:
        :param target:
        :return:
        """
        left, right = 0, len(nums) - 1
        while left <= right:
            mid = (left + right) >> 1
            if nums[mid] >= target:
                # 相等了不想返回,继续压缩右指针
                right = mid - 1
            else:
                left = mid + 1
        return left


if __name__ == '__main__':
    # result = Solution().distributeCoins([1, 2, 4, 4, 5, 6, 7], 4)
    result = Solution().distributeCoins([1, 2, 4, 4, 4, 5, 6, 7], 3)
    print(result)
