"""
二进制链表转整数
"""
from typing import Optional


class ListNode:
    def __init__(self, val=0, next=None):
        self.val = val
        self.next = next


class Solution:
    def getDecimalValue(self, head: ListNode) -> int:
        """
        二进制链表转整数:头节点是高位
        :param head:
        :return:
        """
        res = 0
        while head:
            # *2相当于左移一位
            res = res * 2 + head.val
            head = head.next
        return res


if __name__ == '__main__':
    # 头节点是高位
    # 1, 2, 6, 3, 4, 5, 6
    l1 = ListNode(1)
    l1.next = ListNode(0)
    l1.next.next = ListNode(1)
    # l1.next.next.next = ListNode(3)
    # l1.next.next.next.next = ListNode(2)
    # l1.next.next.next.next.next = ListNode(1)
    # l1.next.next.next.next.next.next = ListNode(7)
    # l2 = ListNode(5)
    # l2.next = ListNode(6)
    # l2.next.next = ListNode(1)
    # l2.next.next.next = ListNode(8)
    # l2.next.next.next.next = ListNode(4)
    # l2.next.next.next.next.next = ListNode(5)
    result = Solution().getDecimalValue(l1)
    print(result)
    # while result:
    #     print(result.val, end=' -> ')
    #     result = result.next
