"""
环形子数组的最大和


算法思路：

首先，我们先来计算不考虑环形的情况下，最大子数组和和最小子数组和。可以使用 Kadane 算法来计算。
然后，我们计算数组的总和。
接下来，我们考虑环形的情况。如果我们把环形数组看成两个数组，那么它们的最大子数组和分别是 max_sum 和 total_sum - min_sum，其中 total_sum 是数组的总和，min_sum 是两个数组的最小子数组和。
最后，我们比较 max_sum 和 total_sum - min_sum，取最大值作为环形数组的最大子数组和。
需要注意的是，如果 max_sum 大于 0，那么结果就是 max(max_sum, total_sum - min_sum)，否则结果就是 max_sum。
"""
from typing import List


class Solution:
    def maxSubarraySumCircular(self, nums: List[int]) -> int:
        """
        Kadane算法
        :param nums:
        :return:
        """
        n = len(nums)
        max_sum, min_sum = nums[0], nums[0]  # 记录最大子数组和和最小子数组和
        cur_max, cur_min = nums[0], nums[0]  # 记录当前子数组和
        total_sum = nums[0]  # 记录数组总和

        for i in range(1, n):
            total_sum += nums[i]
            cur_max = max(cur_max + nums[i], nums[i])
            max_sum = max(max_sum, cur_max)
            cur_min = min(cur_min + nums[i], nums[i])
            min_sum = min(min_sum, cur_min)

        return max(max_sum, total_sum - min_sum) if max_sum > 0 else max_sum


if __name__ == '__main__':
    result = Solution().maxSubarraySumCircular([1, -2, 3, -2])
    print(result)
