"""
二分查找Rightmost,插入元素在最右边
"""

from typing import List


class Solution:
    def distributeCoins(self, nums: List[int], target: int) -> int:
        """
        二分查找Rightmost,插入元素在最右边,返回的是插入的index,如果是排名需要再加1
        :param nums:
        :param target:
        :return:
        """
        left, right = 0, len(nums) - 1
        while left <= right:
            mid = (left + right) >> 1
            if nums[mid] > target:
                right = mid - 1
            else:
                # 最后等于最后一个目标值的时候,又加了一次,所以在结果的时候需要减1
                left = mid + 1
        return left


if __name__ == '__main__':
    # result = Solution().distributeCoins([1, 2, 4, 4, 5, 6, 7], 4)
    result = Solution().distributeCoins([1, 2, 4, 4, 4, 6, 7], 5)
    print(result)
