"""
回文链表
"""
from typing import Optional


class ListNode:
    def __init__(self, val=0, next=None):
        self.val = val
        self.next = next


class Solution:
    def isPalindrome(self, head: Optional[ListNode]) -> bool:
        """
        回文链表
        :param head:
        :return:
        """
        contain = []
        curr = head
        while curr is not None:
            contain.append(curr.val)
            curr = curr.next
        curr2 = head
        while curr2 is not None:
            if contain.pop() != curr2.val:
                return False
            curr2 = curr2.next
        return True


if __name__ == '__main__':
    # 1, 2, 6, 3, 4, 5, 6
    l1 = ListNode(1)
    l1.next = ListNode(2)
    l1.next.next = ListNode(3)
    l1.next.next.next = ListNode(3)
    l1.next.next.next.next = ListNode(2)
    l1.next.next.next.next.next = ListNode(1)
    # l1.next.next.next.next.next.next = ListNode(7)
    # l2 = ListNode(5)
    # l2.next = ListNode(6)
    # l2.next.next = ListNode(1)
    # l2.next.next.next = ListNode(8)
    # l2.next.next.next.next = ListNode(4)
    # l2.next.next.next.next.next = ListNode(5)
    result = Solution().isPalindrome(l1)
    print(result)
