"""
二分查找Rightmost
"""

from typing import List


class Solution:
    def distributeCoins(self, nums: List[int], target: int) -> int:
        """
        二分查找Rightmost,最右侧的重复元素
        :param nums:
        :param target:
        :return:
        """
        left, right = 0, len(nums) - 1
        candidate = -1
        while left <= right:
            mid = (left + right) >> 1
            if nums[mid] > target:
                right = mid - 1
            elif nums[mid] < target:
                left = mid + 1
            else:
                # 找到后把值给候选人,右指针继续递减
                candidate = mid
                left = mid + 1
        return candidate


if __name__ == '__main__':
    # result = Solution().distributeCoins([1, 2, 4, 4, 5, 6, 7], 4)
    result = Solution().distributeCoins([1, 2, 4, 4, 4, 5, 6, 7], 4)
    print(result)
