"""
二分查找改变版
"""

from typing import List


class Solution:
    def distributeCoins(self, nums: List[int], target: int) -> int:
        """
        二分查找改变版,如果增大了右边界,那最后的结果肯定不能取到right
        :param nums:
        :param target:
        :return:
        """
        left, right = 0, len(nums)
        while left < right:
            mid = (left + right) >> 1
            if nums[mid] > target:
                right = mid
            elif nums[mid] < target:
                left = mid + 1
            else:
                return mid
        return -1


if __name__ == '__main__':
    result = Solution().distributeCoins([2, 7, 11, 15], 11)
    print(result)
