"""
二分查找基础版
"""

from typing import List

class Solution:
    def distributeCoins(self, nums: List[int], target: int) -> int:
        """
        二分查找基础版
        :param nums:
        :param target:
        :return:
        """
        left, right = 0, len(nums) - 1
        while left <= right:
            mid = (left + right) >> 1
            if nums[mid] > target:
                right = mid - 1
            elif nums[mid] < target:
                left = mid + 1
            else:
                return mid
        return -1


if __name__ == '__main__':
    result = Solution().distributeCoins([2, 7, 11, 15], 0)
    print(result)
